# Monaco Institute of Business and Computer Science
## Django Web Application

A full-featured Django website for Monaco Institute, modeled after the MTAC Uganda design.

---

## 🚀 Quick Setup

### 1. Create Virtual Environment
```bash
python -m venv venv
source venv/bin/activate      # Linux/Mac
# OR
venv\Scripts\activate         # Windows
```

### 2. Install Dependencies
```bash
pip install -r requirements.txt
```

### 3. Run Migrations
```bash
python manage.py migrate
```

### 4. Seed Sample Data
```bash
python manage.py seed_data
```

### 5. Create Admin User
```bash
python manage.py createsuperuser
```

### 6. Collect Static Files (for production)
```bash
python manage.py collectstatic
```

### 7. Run Development Server
```bash
python manage.py runserver
```

---

## 🌐 URLs

| URL | Description |
|-----|-------------|
| http://127.0.0.1:8000/ | Homepage |
| http://127.0.0.1:8000/about/ | About Us |
| http://127.0.0.1:8000/courses/ | All Courses |
| http://127.0.0.1:8000/courses/degree/ | Degree Programmes |
| http://127.0.0.1:8000/courses/diploma/ | Diploma Courses |
| http://127.0.0.1:8000/courses/certificate/ | Certificate Courses |
| http://127.0.0.1:8000/courses/short/ | Short Courses |
| http://127.0.0.1:8000/courses/vocational/ | Vocational Courses |
| http://127.0.0.1:8000/admissions/ | Online Admissions Form |
| http://127.0.0.1:8000/news/ | News & Events |
| http://127.0.0.1:8000/gallery/ | Photo Gallery |
| http://127.0.0.1:8000/faculty/ | Faculty & Staff |
| http://127.0.0.1:8000/contact/ | Contact Us |
| http://127.0.0.1:8000/admin/ | Admin Dashboard |

---

## 📦 Features

### Frontend Website
- ✅ Responsive design (Bootstrap 5)
- ✅ Hero image slider
- ✅ Course catalog (Degree, Diploma, Certificate, Short, Vocational)
- ✅ Online admissions form
- ✅ News & Events with pagination
- ✅ Photo Gallery with category filtering
- ✅ Faculty & Staff directory
- ✅ Contact form
- ✅ Notice board & Downloads sidebar
- ✅ AOS scroll animations
- ✅ Mobile-friendly navigation

### Admin Dashboard
- ✅ Course management (add/edit/delete)
- ✅ Slider/banner management
- ✅ News & Events management
- ✅ Application tracking (with status updates)
- ✅ Contact message inbox
- ✅ Faculty management
- ✅ Gallery management
- ✅ Downloads management
- ✅ Site settings (contact info, social media, director message)

---

## 🎨 Design
Colors:
- Primary: #1a3a6b (Deep Navy Blue)
- Accent: #e8a020 (Golden Orange)
- Background: #f5f7fa

Fonts: Open Sans + Montserrat

---

## 📁 Project Structure
```
monaco_institute/
├── manage.py
├── requirements.txt
├── README.md
├── monaco_institute/
│   ├── settings.py
│   ├── urls.py
│   └── wsgi.py
├── main/
│   ├── models.py          # Database models
│   ├── views.py           # View logic
│   ├── urls.py            # URL routing
│   ├── admin.py           # Admin configuration
│   ├── forms.py           # Forms
│   ├── templates/main/    # HTML templates
│   ├── static/main/css/   # Stylesheets
│   └── management/commands/seed_data.py
└── media/                 # Uploaded files
```

---

## 🔧 Customization

### Change Colors
Edit `main/static/main/css/style.css`:
```css
:root {
    --primary: #1a3a6b;   /* Change primary color */
    --accent: #e8a020;    /* Change accent color */
}
```

### Add Courses
Login to admin → Courses → Add Course

### Update Site Settings
Admin → Site Settings → Edit contact info, director message, social links

---

## 📧 Production Notes
- Change `SECRET_KEY` in settings.py
- Set `DEBUG = False`
- Configure proper database (PostgreSQL recommended)
- Set up proper email backend for form submissions
- Configure ALLOWED_HOSTS with your domain
