from django.core.management.base import BaseCommand
from main.models import Course, SiteSettings, News, Download


class Command(BaseCommand):
    help = 'Seed the database with sample data for Monaco Institute'

    def handle(self, *args, **kwargs):
        # Site Settings
        settings, _ = SiteSettings.objects.get_or_create(pk=1)
        settings.site_name = "Monaco Institute of Business and Computer Science"
        settings.tagline = "Excellence in Business & Technology Education"
        settings.email = "info@monaco-institute.edu"
        settings.phone = "+377 98 000 0000"
        settings.address = "23 Avenue de Monte-Carlo, Monaco MC 98000"
        settings.about_text = (
            "Monaco Institute of Business and Computer Science is a prestigious institution "
            "dedicated to providing world-class education in business administration, information "
            "technology, and computer science. Founded in 1999, we have been shaping the business "
            "and technology leaders of tomorrow with a blend of academic excellence and practical "
            "industry experience. Our programs are accredited internationally and recognized by "
            "leading employers worldwide."
        )
        settings.director_name = "Prof. Jean-Pierre Fontaine"
        settings.director_message = (
            "Welcome to Monaco Institute of Business and Computer Science. Our institution stands "
            "at the intersection of innovation and tradition, providing students with the tools, "
            "knowledge, and networks they need to succeed in today's dynamic global economy. "
            "We are committed to nurturing intellectual curiosity, entrepreneurial thinking, and "
            "ethical leadership. I invite you to explore our programs and discover how Monaco "
            "Institute can be the launchpad for your successful career."
        )
        settings.facebook_url = "https://facebook.com"
        settings.twitter_url = "https://twitter.com"
        settings.linkedin_url = "https://linkedin.com"
        settings.save()
        self.stdout.write(self.style.SUCCESS('✓ Site settings created'))

        # Courses
        courses_data = [
            # Degrees
            ('Bachelor of Business Administration', 'degree', 'A comprehensive undergraduate program covering all aspects of modern business management, entrepreneurship, and leadership.', '3 Years', 'A-Level or equivalent with 3 passes', 8500.00),
            ('Bachelor of Computer Science', 'degree', 'An in-depth study of computing principles, software development, artificial intelligence, and data science.', '3 Years', 'A-Level with Mathematics or Computing', 9000.00),
            ('Bachelor of Information Technology', 'degree', 'Focuses on IT infrastructure, cybersecurity, networking, and digital transformation.', '3 Years', 'A-Level or equivalent', 8500.00),
            # Diplomas
            ('Diploma in Business Management', 'diploma', 'Equips students with practical business management skills including finance, marketing, and operations.', '2 Years', 'O-Level or equivalent with 5 passes', 4500.00),
            ('Diploma in Software Development', 'diploma', 'Covers programming, web development, database management, and software engineering principles.', '2 Years', 'O-Level with Mathematics', 5000.00),
            ('Diploma in Accounting & Finance', 'diploma', 'Provides comprehensive training in financial accounting, management accounting, and auditing.', '2 Years', 'O-Level or equivalent', 4500.00),
            ('Diploma in Human Resource Management', 'diploma', 'Covers talent acquisition, employee relations, organizational development, and HR strategy.', '2 Years', 'O-Level or equivalent', 4000.00),
            # Certificates
            ('Certificate in Business Administration', 'certificate', 'An introductory program covering core business concepts, communication, and entrepreneurship.', '1 Year', 'O-Level or equivalent', 2500.00),
            ('Certificate in Computer Applications', 'certificate', 'Practical training in Microsoft Office, internet applications, and basic programming.', '6 Months', 'Basic literacy required', 1500.00),
            ('Certificate in Digital Marketing', 'certificate', 'Covers social media marketing, SEO, content marketing, and digital advertising strategies.', '6 Months', 'O-Level or equivalent', 1800.00),
            # Short Courses
            ('Excel for Business Professionals', 'short', 'Advanced Excel skills for data analysis, financial modeling, and business reporting.', '3 Weeks', 'Basic computer knowledge', 350.00),
            ('Project Management Fundamentals', 'short', 'Introduction to project management methodologies including Agile, Scrum, and PMP frameworks.', '4 Weeks', 'Any qualification', 420.00),
            ('Python Programming Bootcamp', 'short', 'Intensive hands-on Python programming for beginners and intermediate learners.', '6 Weeks', 'Basic computer knowledge', 600.00),
            ('Leadership & Management Skills', 'short', 'Develop essential leadership, communication, and team management capabilities.', '2 Weeks', 'Any qualification', 300.00),
            # Vocational
            ('Web Design & Development', 'vocational', 'Practical skills in HTML, CSS, JavaScript, and building professional websites.', '4 Months', 'Basic computer literacy', 1200.00),
            ('Graphic Design', 'vocational', 'Training in Adobe Photoshop, Illustrator, and professional design principles.', '3 Months', 'Basic computer literacy', 900.00),
        ]

        for title, ctype, desc, duration, req, fees in courses_data:
            Course.objects.get_or_create(
                title=title,
                defaults={
                    'course_type': ctype,
                    'description': desc,
                    'duration': duration,
                    'entry_requirements': req,
                    'fees': fees,
                    'is_active': True,
                }
            )
        self.stdout.write(self.style.SUCCESS(f'✓ {len(courses_data)} courses created'))

        # News
        news_data = [
            ('Monaco Institute Opens New Computer Lab', 'news', 'We are pleased to announce the opening of our state-of-the-art computer laboratory equipped with the latest hardware and software to support our IT and computer science students in their practical training.', 'Monaco Institute has opened a new 60-seat computer laboratory.'),
            ('2026 Intake: Applications Now Open', 'admission', 'Applications for the 2026 academic year are now open for all programmes. Interested candidates are encouraged to apply early as places are limited. Visit our admissions page or come in person to collect an application form.', 'Applications for 2026 intake are now open.'),
            ('Annual Business Symposium - March 2026', 'event', 'Monaco Institute will host its Annual Business Symposium on March 15, 2026. The theme this year is "Digital Transformation and the Future of Business." Guest speakers include senior executives from leading Monaco and European companies.', 'Annual Business Symposium scheduled for March 2026.'),
            ('Graduation Ceremony Highlights 2025', 'news', 'Congratulations to the Class of 2025! Our annual graduation ceremony was a resounding success with over 500 students receiving their qualifications. The ceremony was attended by dignitaries, parents, and industry partners.', 'Class of 2025 graduation ceremony was a great success.'),
            ('Student Achievement Awards', 'news', 'Monaco Institute recognizes outstanding academic performance with our annual Student Achievement Awards. This year, 25 students received awards across all faculties for maintaining exceptional GPA scores throughout their programs.', 'Annual student achievement awards ceremony held.'),
        ]

        for title, category, content, excerpt in news_data:
            News.objects.get_or_create(
                title=title,
                defaults={
                    'category': category,
                    'content': content,
                    'excerpt': excerpt,
                    'is_published': True,
                }
            )
        self.stdout.write(self.style.SUCCESS(f'✓ {len(news_data)} news articles created'))

        # Downloads
        self.stdout.write(self.style.WARNING('⚠ Downloads require actual files - add them via admin panel'))

        self.stdout.write(self.style.SUCCESS('\n✅ Sample data seeded successfully!'))
        self.stdout.write(self.style.SUCCESS('Next steps:'))
        self.stdout.write('  1. python manage.py createsuperuser')
        self.stdout.write('  2. python manage.py runserver')
        self.stdout.write('  3. Visit http://127.0.0.1:8000')
        self.stdout.write('  4. Admin at http://127.0.0.1:8000/admin')
