from django.urls import path
from . import views

urlpatterns = [
    path('', views.home, name='home'),
    path('about/', views.about, name='about'),
    path('courses/', views.courses_list, name='courses'),
    path('courses/<str:course_type>/', views.courses_list, name='courses_by_type'),
    path('course/<int:pk>/', views.course_detail, name='course_detail'),
    path('admissions/', views.admissions, name='admissions'),
    path('news/', views.news_list, name='news'),
    path('news/<int:pk>/', views.news_detail, name='news_detail'),
    path('gallery/', views.gallery, name='gallery'),
    path('contact/', views.contact, name='contact'),
    path('faculty/', views.faculty_list, name='faculty'),
    path('staff/', views.staff_list, name='staff'),
    path('innovation-hub/', views.innovation_hub, name='innovation_hub'),
]
